import { StarXpandCommand } from "star-io10-web";

export class LabelSample17_For203dpiAnd300dpi_PharmacyMedication2_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 72.0 for 203dpi, 48.7 for 300dpi
        .settingPrintableArea(72.0)
        //.settingPrintableArea(48.7)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            .actionPrintText(
              "${patient_name} 様",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "処方日 ${prescription_date}  \n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText(
              "調剤日 ${dispensing_date}  \n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                48,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .actionPrintText("${hospital_name}:\n")
            .actionFeedLine(1)
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "  ${item_list1.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    17,
                    new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                      StarXpandCommand.Printer.TextWidthType.Full,
                    ),
                  ),
                )
                .actionPrintText(
                  "${item_list1.take_the_medicine}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(5),
                )
                .actionPrintText(
                  "${item_list1.dosage}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(9),
                ),
            )
            .actionPrintText(
              "  ----------------------------------------------\n",
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "  ${item_list2.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    17,
                    new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                      StarXpandCommand.Printer.TextWidthType.Full,
                    ),
                  ),
                )
                .actionPrintText(
                  "${item_list2.take_the_medicine}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(5),
                )
                .actionPrintText(
                  "${item_list2.dosage}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(9),
                )
                .actionPrintText("　${item_list2.note}\n"),
            )
            .actionPrintText(
              "  ----------------------------------------------\n",
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "  ${item_list3.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    17,
                    new StarXpandCommand.Printer.TextWidthParameter().setWidthType(
                      StarXpandCommand.Printer.TextWidthType.Full,
                    ),
                  ),
                )
                .actionPrintText(
                  "${item_list3.take_the_medicine}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(5),
                )
                .actionPrintText(
                  "${item_list3.dosage}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(9),
                )
                .actionPrintText("　${item_list3.note}\n"),
            )
            .actionPrintText(
              "  ----------------------------------------------\n",
            )
            .actionPrintText("${store_name}  TEL ${telephone_number}\n")
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "patient_name" : "シズオカ タロウ",
    "prescription_date" : "2018年01月10日",
    "dispensing_date" : "2018年01月11日",
    "hospital_name" : "ＳＴＡＲ総合病院",
    "item_list1" : [
        {
            "name" : "スター錠",
            "take_the_medicine" : "(1日)",
            "dosage" : "3錠"
        },
        {
            "name" : "ＡＢＣ２５０ｍｇ",
            "take_the_medicine" : "(1日)",
            "dosage" : "3Ｃ"
        },
        {
            "name" : "スター散",
            "take_the_medicine" : "(1日)",
            "dosage" : "3ｇ"
        },
        {
            "name" : "いろは錠",
            "take_the_medicine" : "(1日)",
            "dosage" : "1錠"
        },
        {
            "name" : "スター顆粒",
            "take_the_medicine" : "(1日)",
            "dosage" : "1ｇ"
        },
        {
            "name" : "あいう錠",
            "take_the_medicine" : "(1日)",
            "dosage" : "3Ｔ"
        }
    ],
    "item_list2" : [
        {
            "name" : "Ｂ頭痛薬",
            "take_the_medicine" : "(1日)",
            "dosage" : "0.5Ｔ",
            "note" : "　頭痛時にお飲みください。　　　　5回分"
        }
    ],
    "item_list3" : [
        {
            "name" : "Ｉうがい薬",
            "take_the_medicine" : "",
            "dosage" : "",
            "note" : "　　　　　　　　　　　　　　　　　1回分"
        }
    ],
    "store_name" : "ラベル.STAR薬局",
    "telephone_number" : "0123-456-789"
}`,
    );
  }
}
